function value = value_default_leg_CDS(date_nums, T, coupon, LGD, discounts, discounts_inbetween, default_probs)
% --------------------------------------------------------------------------------------------------
% Calculate the market value of the payments made by the seller of protection.
% --------------------------------------------------------------------------------------------------
% date_nums             ... datenums for which to calculate model-implied price
% T                     ... time to maturity of index
% coupon                ... coupon rates for individual tranches
% LGD                   ... loss given default
% discounts             ... discount curve (quarterly frequency, end of period)
% discounts_inbetween   ... discount curve (quarterly frequency, middle of period)
% default_probs         ... matrix where entry (i,j) gives the probability for the i-th date, for
%                           the j-th time horizon.
% --------------------------------------------------------------------------------------------------
% sample call: value_default_leg_CDS(cds_test.dates{1}, 5, cds_test.market_price{1}, ...)
% --------------------------------------------------------------------------------------------------

% Cut default probabilities down to relevant dates & horizons
[trash, used_dates] = is_member_sorted_c(date_nums, default_probs.dates);
missing = find(used_dates==0);
% If data not available, use most recently available data
for i=1:length(missing)
    pos = missing(i) - 1;
    found = false;
    while ((~found) && (pos > 0))
       if (~is_member_sorted_c(pos, missing))
           used_dates(missing(i)) = used_dates(pos);
           found = true;
       end
       pos = pos - 1;
    end
end

% Calculate value of default leg
value = zeros(length(coupon), 1);
for i=1:length(value)
    % Calculate value of payments due to losses, including accrued premium at time of default
    T_max = ceil(T(i)*4);
    default_probs_t = default_probs.default_probs(used_dates(i), 1:T_max);
    value(i) = sum(default_probs_t .* discounts_inbetween(i,1:T_max)) * (LGD - coupon(i)/1e4/4/2*(365/360));
end